/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.network.ActiveStateSyncMessage;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public interface ISlashBladeState
extends INBTSerializable<CompoundTag> {
    default public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("lastActionTime", this.getLastActionTime());
        tag.m_128405_("TargetEntity", this.getTargetEntityId());
        tag.m_128379_("_onClick", this.onClick());
        tag.m_128350_("fallDecreaseRate", this.getFallDecreaseRate());
        tag.m_128350_("AttackAmplifier", this.getAttackAmplifier());
        tag.m_128359_("currentCombo", this.getComboSeq().toString());
        tag.m_128405_("Damage", this.getDamage());
        tag.m_128405_("maxDamage", this.getMaxDamage());
        tag.m_128405_("proudSoul", this.getProudSoulCount());
        tag.m_128379_("isBroken", this.isBroken());
        tag.m_128379_("isSealed", this.isSealed());
        tag.m_128350_("baseAttackModifier", this.getBaseAttackModifier());
        tag.m_128405_("killCount", this.getKillCount());
        tag.m_128405_("RepairCounter", this.getRefine());
        UUID bladeId = this.getUniqueId();
        tag.m_128362_("BladeUniqueId", bladeId);
        tag.m_128359_("SpecialAttackType", Optional.ofNullable(this.getSlashArtsKey()).orElse(SlashArtsRegistry.JUDGEMENT_CUT.getId()).toString());
        tag.m_128379_("isDefaultBewitched", this.isDefaultBewitched());
        tag.m_128359_("translationKey", this.getTranslationKey());
        tag.m_128344_("StandbyRenderType", (byte)this.getCarryType().ordinal());
        tag.m_128405_("SummonedSwordColor", this.getColorCode());
        tag.m_128379_("SummonedSwordColorInverse", this.isEffectColorInverse());
        tag.m_128365_("adjustXYZ", (Tag)NBTHelper.newDoubleNBTList(this.getAdjust()));
        this.getTexture().ifPresent(loc -> tag.m_128359_("TextureName", loc.toString()));
        this.getModel().ifPresent(loc -> tag.m_128359_("ModelName", loc.toString()));
        tag.m_128359_("ComboRoot", Optional.ofNullable(this.getComboRoot()).orElse(ComboStateRegistry.STANDBY.getId()).toString());
        if (this.getSpecialEffects() != null && !this.getSpecialEffects().isEmpty()) {
            ListTag seList = new ListTag();
            this.getSpecialEffects().forEach(se -> seList.add((Object)StringTag.m_129297_((String)se.toString())));
            tag.m_128365_("SpecialEffects", (Tag)seList);
        }
        return tag;
    }

    default public void deserializeNBT(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        this.setLastActionTime(tag.m_128454_("lastActionTime"));
        this.setTargetEntityId(tag.m_128451_("TargetEntity"));
        this.setOnClick(tag.m_128471_("_onClick"));
        this.setFallDecreaseRate(tag.m_128457_("fallDecreaseRate"));
        this.setAttackAmplifier(tag.m_128457_("AttackAmplifier"));
        this.setComboSeq(ResourceLocation.m_135820_((String)tag.m_128461_("currentCombo")));
        this.setDamage(tag.m_128451_("Damage"));
        this.setMaxDamage(tag.m_128451_("maxDamage"));
        this.setProudSoulCount(tag.m_128451_("proudSoul"));
        this.setBroken(tag.m_128471_("isBroken"));
        this.setHasChangedActiveState(true);
        this.setSealed(tag.m_128471_("isSealed"));
        this.setBaseAttackModifier(tag.m_128457_("baseAttackModifier"));
        this.setKillCount(tag.m_128451_("killCount"));
        this.setRefine(tag.m_128451_("RepairCounter"));
        this.setUniqueId(tag.m_128403_("BladeUniqueId") ? tag.m_128342_("BladeUniqueId") : UUID.randomUUID());
        this.setSlashArtsKey(ResourceLocation.m_135820_((String)tag.m_128461_("SpecialAttackType")));
        this.setDefaultBewitched(tag.m_128471_("isDefaultBewitched"));
        this.setTranslationKey(tag.m_128461_("translationKey"));
        this.setCarryType((CarryType)EnumSetConverter.fromOrdinal((Enum[])CarryType.values(), (int)tag.m_128445_("StandbyRenderType"), (Enum)CarryType.PSO2));
        this.setColorCode(tag.m_128451_("SummonedSwordColor"));
        this.setEffectColorInverse(tag.m_128471_("SummonedSwordColorInverse"));
        this.setAdjust(NBTHelper.getVector3d(tag, "adjustXYZ"));
        if (tag.m_128441_("TextureName")) {
            this.setTexture(new ResourceLocation(tag.m_128461_("TextureName")));
        } else {
            this.setTexture(null);
        }
        if (tag.m_128441_("ModelName")) {
            this.setModel(new ResourceLocation(tag.m_128461_("ModelName")));
        } else {
            this.setModel(null);
        }
        this.setComboRoot(ResourceLocation.m_135820_((String)tag.m_128461_("ComboRoot")));
        if (tag.m_128441_("SpecialEffects")) {
            ListTag list = tag.m_128437_("SpecialEffects", 8);
            this.setSpecialEffects(list);
        }
    }

    public long getLastActionTime();

    public void setLastActionTime(long var1);

    default public long getElapsedTime(LivingEntity user) {
        long ticks = Math.max(0L, user.m_9236_().m_46467_() - this.getLastActionTime());
        if (user.m_9236_().m_5776_()) {
            ticks = Math.max(0L, ticks + 1L);
        }
        return ticks;
    }

    public boolean onClick();

    public void setOnClick(boolean var1);

    public float getFallDecreaseRate();

    public void setFallDecreaseRate(float var1);

    public float getAttackAmplifier();

    public void setAttackAmplifier(float var1);

    @Nonnull
    public ResourceLocation getComboSeq();

    public void setComboSeq(ResourceLocation var1);

    public boolean isBroken();

    public void setBroken(boolean var1);

    public boolean isSealed();

    public void setSealed(boolean var1);

    public float getBaseAttackModifier();

    public void setBaseAttackModifier(float var1);

    public int getProudSoulCount();

    public void setProudSoulCount(int var1);

    public int getKillCount();

    public void setKillCount(int var1);

    public int getRefine();

    public void setRefine(int var1);

    public UUID getUniqueId();

    public void setUniqueId(UUID var1);

    @Nonnull
    default public SlashArts getSlashArts() {
        ResourceLocation key = this.getSlashArtsKey();
        SlashArts result = null;
        if (key != null) {
            SlashArts slashArts = result = SlashArtsRegistry.REGISTRY.get().containsKey(key) ? (SlashArts)SlashArtsRegistry.REGISTRY.get().getValue(key) : (SlashArts)SlashArtsRegistry.JUDGEMENT_CUT.get();
        }
        if (key == SlashArtsRegistry.NONE.getId()) {
            result = null;
        }
        return result != null ? result : (SlashArts)SlashArtsRegistry.JUDGEMENT_CUT.get();
    }

    public void setSlashArtsKey(ResourceLocation var1);

    public ResourceLocation getSlashArtsKey();

    public boolean isDefaultBewitched();

    public void setDefaultBewitched(boolean var1);

    @Nonnull
    public String getTranslationKey();

    public void setTranslationKey(String var1);

    @Nonnull
    public CarryType getCarryType();

    public void setCarryType(CarryType var1);

    @Nonnull
    public Color getEffectColor();

    public void setEffectColor(Color var1);

    public boolean isEffectColorInverse();

    public void setEffectColorInverse(boolean var1);

    default public void setColorCode(int colorCode) {
        this.setEffectColor(new Color(colorCode));
    }

    default public int getColorCode() {
        return this.getEffectColor().getRGB();
    }

    @Nonnull
    public Vec3 getAdjust();

    public void setAdjust(Vec3 var1);

    @Nonnull
    public Optional<ResourceLocation> getTexture();

    public void setTexture(ResourceLocation var1);

    @Nonnull
    public Optional<ResourceLocation> getModel();

    public void setModel(ResourceLocation var1);

    public int getTargetEntityId();

    public void setTargetEntityId(int var1);

    @Nullable
    default public Entity getTargetEntity(Level world) {
        int id = this.getTargetEntityId();
        if (id < 0) {
            return null;
        }
        return world.m_6815_(id);
    }

    default public void setTargetEntityId(Entity target) {
        if (target != null) {
            this.setTargetEntityId(target.m_19879_());
        } else {
            this.setTargetEntityId(-1);
        }
    }

    default public int getFullChargeTicks(LivingEntity user) {
        return 9;
    }

    default public boolean isCharged(LivingEntity user) {
        if (!SwordType.from(user.m_21205_()).contains((Object)SwordType.ENCHANTED)) {
            return false;
        }
        if (this.isBroken() || this.isSealed()) {
            return false;
        }
        int elapsed = user.m_21252_();
        return this.getFullChargeTicks(user) < elapsed;
    }

    default public ResourceLocation progressCombo(LivingEntity user, boolean isVirtual) {
        ResourceLocation resolved;
        ResourceLocation currentloc = this.resolvCurrentComboState(user);
        ComboState current = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(currentloc);
        if (current == null) {
            return ComboStateRegistry.NONE.getId();
        }
        ResourceLocation next = current.getNext(user);
        if (!next.equals((Object)ComboStateRegistry.NONE.getId()) && next.equals((Object)currentloc)) {
            return ComboStateRegistry.NONE.getId();
        }
        ResourceLocation rootNext = ((ComboState)ComboStateRegistry.REGISTRY.get().getValue(this.getComboRoot())).getNext(user);
        ComboState nextCS = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(next);
        ComboState rootNextCS = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(rootNext);
        ResourceLocation resourceLocation = resolved = nextCS.getPriority() <= rootNextCS.getPriority() ? next : rootNext;
        if (!isVirtual) {
            this.updateComboSeq(user, resolved);
        }
        return resolved;
    }

    default public ResourceLocation progressCombo(LivingEntity user) {
        return this.progressCombo(user, false);
    }

    default public ResourceLocation doChargeAction(LivingEntity user, int elapsed) {
        SlashArts.ArtsType result;
        if (elapsed <= 2) {
            return ComboStateRegistry.NONE.getId();
        }
        if (this.isBroken() || this.isSealed()) {
            return ComboStateRegistry.NONE.getId();
        }
        Map.Entry<Integer, ResourceLocation> currentloc = this.resolvCurrentComboStateTicks(user);
        ComboState current = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(currentloc.getValue());
        if (current == null) {
            return ComboStateRegistry.NONE.getId();
        }
        if (currentloc.getValue() != ComboStateRegistry.NONE.getId() && current.getNext(user) == currentloc.getValue()) {
            return ComboStateRegistry.NONE.getId();
        }
        int fullChargeTicks = this.getFullChargeTicks(user);
        int justReceptionSpan = SlashArts.getJustReceptionSpan(user);
        int justChargePeriod = fullChargeTicks + justReceptionSpan;
        ImmutableRangeMap charge_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(fullChargeTicks)), (Object)SlashArts.ArtsType.Fail).put(Range.closedOpen((Comparable)Integer.valueOf(fullChargeTicks), (Comparable)Integer.valueOf(justChargePeriod)), (Object)SlashArts.ArtsType.Jackpot).put(Range.atLeast((Comparable)Integer.valueOf(justChargePeriod)), (Object)SlashArts.ArtsType.Success).build();
        SlashArts.ArtsType type = (SlashArts.ArtsType)((Object)charge_accept.get((Comparable)Integer.valueOf(elapsed)));
        if (type != SlashArts.ArtsType.Jackpot && (result = current.releaseAction(user, currentloc.getKey())) != SlashArts.ArtsType.Fail) {
            type = result;
        }
        ResourceLocation csloc = this.getSlashArts().doArts(type, user);
        ComboState cs = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(csloc);
        if (csloc != ComboStateRegistry.NONE.getId() && !currentloc.getValue().equals((Object)csloc) && current.getPriority() > cs.getPriority()) {
            if (type == SlashArts.ArtsType.Jackpot) {
                AdvancementHelper.grantedIf(Enchantments.f_44976_, user);
            }
            this.updateComboSeq(user, csloc);
        }
        return csloc;
    }

    default public void updateComboSeq(LivingEntity entity, ResourceLocation loc) {
        MinecraftForge.EVENT_BUS.post((Event)new BladeMotionEvent(entity, loc));
        this.setComboSeq(loc);
        this.setLastActionTime(entity.m_9236_().m_46467_());
        ComboState cs = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(loc);
        cs.clickAction(entity);
    }

    default public ResourceLocation resolvCurrentComboState(LivingEntity user) {
        if (!(user.m_21205_().m_41720_() instanceof ItemSlashBlade)) {
            return ComboStateRegistry.NONE.getId();
        }
        return this.resolvCurrentComboStateTicks(user).getValue();
    }

    default public Map.Entry<Integer, ResourceLocation> resolvCurrentComboStateTicks(LivingEntity user) {
        int time;
        ResourceLocation current = ComboStateRegistry.REGISTRY.get().containsKey(this.getComboSeq()) ? this.getComboSeq() : ComboStateRegistry.NONE.getId();
        ComboState currentCS = ComboStateRegistry.REGISTRY.get().getValue(current) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(current) : (ComboState)ComboStateRegistry.NONE.get();
        for (time = (int)TimeValueHelper.getMSecFromTicks(this.getElapsedTime(user)); !current.equals((Object)ComboStateRegistry.NONE.getId()) && currentCS.getTimeoutMS() < time; time -= currentCS.getTimeoutMS()) {
            current = currentCS.getNextOfTimeout(user);
            this.updateComboSeq(user, current);
        }
        int ticks = (int)TimeValueHelper.getTicksFromMSec(time);
        return new AbstractMap.SimpleImmutableEntry<Integer, ResourceLocation>(ticks, current);
    }

    public ResourceLocation getComboRoot();

    public void setComboRoot(ResourceLocation var1);

    public int getDamage();

    public void setDamage(int var1);

    public int getMaxDamage();

    public void setMaxDamage(int var1);

    public List<ResourceLocation> getSpecialEffects();

    public void setSpecialEffects(ListTag var1);

    public boolean addSpecialEffect(ResourceLocation var1);

    public boolean removeSpecialEffect(ResourceLocation var1);

    public boolean hasSpecialEffect(ResourceLocation var1);

    public boolean hasChangedActiveState();

    public void setHasChangedActiveState(boolean var1);

    default public void sendChanges(Entity entityIn) {
        if (!entityIn.m_9236_().m_5776_() && this.hasChangedActiveState()) {
            ActiveStateSyncMessage msg = new ActiveStateSyncMessage();
            msg.activeTag = this.getActiveState();
            msg.id = entityIn.m_19879_();
            NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entityIn), (Object)msg);
            this.setHasChangedActiveState(false);
        }
    }

    default public CompoundTag getActiveState() {
        CompoundTag tag = new CompoundTag();
        NBTHelper.getNBTCoupler(tag).put("BladeUniqueId", this.getUniqueId()).put("lastActionTime", this.getLastActionTime()).put("TargetEntity", this.getTargetEntityId()).put("_onClick", this.onClick()).put("fallDecreaseRate", Float.valueOf(this.getFallDecreaseRate())).put("AttackAmplifier", Float.valueOf(this.getAttackAmplifier())).put("currentCombo", this.getComboSeq().toString()).put("proudSoul", this.getProudSoulCount()).put("killCount", this.getKillCount()).put("Damage", this.getDamage()).put("isBroken", this.isBroken());
        return tag;
    }

    default public void setActiveState(CompoundTag tag) {
        NBTHelper.getNBTCoupler(tag).get("BladeUniqueId", this::setUniqueId, new UUID[0]).get("lastActionTime", this::setLastActionTime, new Long[0]).get("TargetEntity", id -> this.setTargetEntityId((int)id), new Integer[0]).get("_onClick", this::setOnClick, new Boolean[0]).get("fallDecreaseRate", this::setFallDecreaseRate, new Float[0]).get("AttackAmplifier", this::setAttackAmplifier, new Float[0]).get("currentCombo", s -> this.setComboSeq(ResourceLocation.m_135820_((String)s)), new String[0]).get("proudSoul", this::setProudSoulCount, new Integer[0]).get("killCount", this::setKillCount, new Integer[0]).get("Damage", this::setDamage, new Integer[0]).get("isBroken", this::setBroken, new Boolean[0]);
        this.setHasChangedActiveState(false);
    }
}

